#include <bits/stdc++.h>
using namespace std;

using ll = long long;

struct Fenwick {

	int n;
	vector<ll> stablo;

	Fenwick(int n_ = 0) {

		init(n_);

	}

	void init(int n_) {

		n = n_;
		stablo.assign(n + 1, 0);

	}

	void dodaj(int i, ll v) {

		for (; i <= n; i += i & -i) {

			stablo[i] += v;
        
        }
	}

	ll suma(int i) const {

		ll s = 0;

		for (; i > 0; i -= i & -i) {

			s += stablo[i];

        }

		return s;
	}
};

int main() {

	ios::sync_with_stdio(false);
	cin.tie(nullptr);

	int N, Q;
	cin >> N >> Q;

	vector<int> a(N + 1);
	vector<int> ukupno(N + 1, 0);

	for (int i = 1; i <= N; i++) {

		cin >> a[i];
		ukupno[a[i]]++;

	}

	Fenwick bit(N);

	for (int i = 1; i <= N; i++) {

		bit.dodaj(i, a[i]);

    }

	ll ukupna_suma = 0;

	for (int v = 1; v <= N; v++) {

		ukupna_suma += (ll)ukupno[v] * v;

    }

	while (Q--) {

		int tip;
		cin >> tip;

		if (tip == 1) {

			int k;
			cin >> k;

			unordered_map<int, int> broj;
			broj.reserve(k * 2);

			for (int i = 1; i <= k; i++) {

				broj[a[i]]++;

            }

			ll upareno = 0;

			for (auto &p : broj) {

				int v = p.first;
				int L = p.second;

				int R = ukupno[v] - L;
				upareno += (ll)min(L, R) * v;

			}

			ll odgovor = ukupna_suma - 2 * upareno;
			cout << odgovor << "\n";

		}

		else {

			int x, y;
			cin >> x >> y;

			int staro = a[x];

			if (staro == y) {

				continue;

            }

			ukupno[staro]--;
			ukupno[y]++;

			bit.dodaj(x, -staro);
			bit.dodaj(x, y);

			ukupna_suma -= staro;
			ukupna_suma += y;

			a[x] = y;
		}
	}

	return 0;
}